% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{checkInput}
\alias{checkInput}
\title{Helper function within cyCONDOR}
\usage{
checkInput(
  fcd,
  check_expr_slot = F,
  check_cluster_slot = F,
  check_cell_anno = F,
  check_reduction = F,
  expr_slot = NULL,
  cluster_slot = NULL,
  cluster_var = NULL,
  reduction_method = NULL,
  reduction_slot = NULL,
  group_var = NULL,
  sample_var = NULL,
  pair_var = NULL
)
}
\arguments{
\item{fcd}{flow cytometry dataset}

\item{check_expr_slot}{logical indicating if expr_slot should be checked}

\item{check_cluster_slot}{logical indicating if cluster_slot should be checked}

\item{check_cell_anno}{logical indicating if cell_anno should be checked}

\item{check_reduction}{logical indicating if reduction_method should be checked}

\item{expr_slot}{set to NULL (default) if expr_slot is not needed in parent function, set equal to expr_slot if expr_slot string should be checked}

\item{cluster_slot}{set to NULL (default) if cluster_slot is not needed in parent function, set equal to cluster_slot if cluster_slot string should be checked}

\item{cluster_var}{set to NULL (default) if cluster_var is not needed in parent function, set equal to cluster_var if cluster_var string should be checked}

\item{reduction_method}{set to NULL (default) if reduction_method is not needed in parent function, set equal to reduction_method if reduction_method string should be checked}

\item{reduction_slot}{set to NULL (default) if reduction_slot is not needed in parent function, set equal to reduction_slot if reduction_slot string should be checked}

\item{group_var}{set to NULL (default) if group_var is not needed in parent function, set equal to group_var if group_var string should be checked}

\item{sample_var}{set to NULL (default) if sample_var is not needed in parent function, set equal to sample_var if sample_var string should be checked}

\item{pair_var}{set to NULL (default) if pair_var is not needed in parent function, set equal to pair_var if pair_var string should be checked}
}
\value{
`checkInput()` returns an stop message if one of the checks fails.
}
\description{
`checkInput()` is a helper function within several cyCONDOR functions for visualization and differential testing.
It checks availability if selected 1st level elements (clustering) and 2nd level elements (expr_slot, cluster_slot, cell_anno),
and 3rd level variable names in cluster_slot and cell_anno are present.
In order to ensure proper functioning, all arguments that are strictly necessary in the parent function and
for which no default can be given, should NOT be set to NULL. Please note that this function does not give an error, when group_var, sample_var or pair_var were set to NULL by user in parent function, since these arguments are sometimes optional in the functions.
}
\details{
checkInput
}
