% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_load_and_transform.R
\name{export_sce}
\alias{export_sce}
\title{Export Flow Cytometry Dataset as SCE.}
\usage{
export_sce(
  fcd = condor,
  expr_slot = "orig",
  reduction_method = NULL,
  reduction_slot = NULL,
  cluster_slot = NULL,
  cluster_var = NULL,
  save = TRUE,
  dir = paste0(getwd(), "/"),
  filename = ""
)
}
\arguments{
\item{fcd}{flow cytometry data set}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".}

\item{reduction_method}{string specifying which dimensionality reduction method to use.}

\item{reduction_slot}{string specifying reduction name in reduction_method to use for visualization, e.g. "pca_orig".}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var.}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels). Must be numeric in this function - factors are converted automatically.}

\item{save}{boolean indicating if the sce should be saved as RDS file.}

\item{dir}{string specifying the directory where the RDS file is saved. Current working directory by default.}

\item{filename}{string specifying the filename for the RDS file.}
}
\value{
The SCE  plus a short message if the RDS file was saved successfully.
}
\description{
This function creates an object of the class Single Cell Experiment (SCE) based on the data of the flow cytometry dataset (fcd).
}
\details{
Save the results from cyCONDOR as a Single Cell Experiment Class as RDS file
}
