% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_testing.R
\name{frequency_anova_test}
\alias{frequency_anova_test}
\title{Anova test to compare cell population frequencies of independent samples}
\usage{
frequency_anova_test(
  fcd,
  cluster_slot,
  cluster_var,
  sample_var,
  group_var,
  anova_p.adjust.method = "bonferroni",
  numeric = F,
  post_hoc_test = NULL,
  post_hoc_p.adjust.method = "bonferroni",
  anova_sig_threshold = 0.05,
  print_results = T
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{sample_var}{string indicating variable in cell_anno that defines sample IDs to be used.}

\item{group_var}{string indicating variable in cell_anno that should be used to group samples in sample_var. group_var must have three or more levels.}

\item{anova_p.adjust.method}{p-value adjustment method to use for multiple test correction of Anova tests, e.g "bonferroni"(default) or "BH" (Benjamini-Hochberg). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{numeric}{logical, if TRUE numeric levels in cluster_var are ordered in ascending order and "Cluster_" is pasted before number, if FALSE alphabetical ordering is applied.}

\item{post_hoc_test}{string specifying which post hoc test to perform. Select \code{"tukey"} (balanced data is required to perform a Tukey HSD test) or \code{"emmeans"}. By default no post-hoc test is performed.}

\item{post_hoc_p.adjust.method}{p-value adjustment method to use for post-hoc testing using \code{"emmeans"}, e.g "bonferroni" (default). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{anova_sig_threshold}{significance threshold of the Anova test. For all Anova tests with an adjusted p-value equal or smaller than the threshold, post-hoc tests are performed (default 0.05)}

\item{print_results}{Logical, indicating if the test results are printed to the console (TRUE) or not (FALSE).}
}
\value{
\code{frequency_anova_test()} returns the fcd containing two data frames, "anova" and "annova_pht". "anova" comprises results produced by \code{\link[rstatix]{anova_test}} and "anova_pht" contains results obtained by \code{\link[rstatix]{emmeans_test}}. Both data frames have one additional columns, "cluster", containing the information, which cell population was tested. Results are stored in the fcd under extras$statistics.
}
\description{
\code{frequency_anova_test()} performs an independent measures Anova to compare cell population frequencies of three of more groups. Optionally, post-hoc testing is performed using Emmeans test.
}
\details{
frequency_anova_test

\code{frequency_anova_test()} is a wrapper function around \code{\link[rstatix]{anova_test}}, \code{\link[rstatix]{tukey_hsd}} and \code{\link[rstatix]{emmeans_test}} implemented in the package \code{rstatix}.
The function first calculates cell population frequencies for each sample in sample_var. Then a independent measures, one-way Anova test is performed for each cell population followed by p-value adjustment. If \code{post_hoc = T}, post-hoc testing with pairwise emmeans tests and p-value correction is performed for each significant Anova test.
}
