% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_testing.R
\name{frequency_friedman_test}
\alias{frequency_friedman_test}
\title{Friedman Rank Sum test to compare cell population frequencies of paired samples}
\usage{
frequency_friedman_test(
  fcd,
  cluster_slot,
  cluster_var,
  sample_var,
  group_var,
  pair_var,
  friedman_p.adjust.method = "bonferroni",
  numeric = F,
  post_hoc_test = F,
  post_hoc_p.adjust.method = "bonferroni",
  friedman_sig_threshold = 0.05,
  print_results = T
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{sample_var}{string indicating variable in cell_anno that defines sample IDs to be used.}

\item{group_var}{string indicating variable in cell_anno that should be used to group samples in sample_var. group_var must have three or more levels.}

\item{pair_var}{string indicating variable in cell_anno that should be used to pair the samples.}

\item{friedman_p.adjust.method}{p-value adjustment method to use for multiple comparisons of Friedman Rank Sum test, e.g "bonferroni" (default) or "BH" (Benjamini-Hochberg). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{numeric}{logical, if TRUE numeric levels in cluster_var are ordered in ascending order and "Cluster_" is pasted before number, if FALSE alphabetical ordering is applied.}

\item{post_hoc_test}{logical, whether to perform post-hoc testing (TRUE, default) or not (FALSE).}

\item{post_hoc_p.adjust.method}{p-value adjustment method to use for post-hoc testing, e.g "bonferroni" (default). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{friedman_sig_threshold}{significance threshold Friedman Rank Sum test. For all Friedman Rank Sum comparisons with an adjusted p-value equal or smaller than the threshold, post-hoc tests are performed (default 0.05)}

\item{print_results}{Logical, indicating if the test results are printed to the console (TRUE) or not (FALSE).}
}
\value{
\code{frequency_friedman_test} returns the fcd containing two data frames, "friedman" and "friedman_pht". "friedman" comprises results produced by \code{\link[rstatix]{friedman_test}} and \code{\link[rstatix]{friedman_effsize}} and "friedman_pht" contains results obtained by \code{\link[rstatix]{wilcox_test}}. Both data frames have one additional columns, "cluster", containing the information, which cell population was tested. Results are stored in the fcd under extras$statistics.
}
\description{
\code{frequency_friedman_test()} performs a Friedman Rank Sum test to compare cell population frequencies of three of more groups. Optionally, post-hoc testing is performed using Wilcoxon Rank Sum test.
}
\details{
frequency_friedman_test

\code{frequency_friedman_test()} is a wrapper function around \code{\link[rstatix]{friedman_test}},  \code{\link[rstatix]{friedman_effsize}} and  \code{\link[rstatix]{wilcox_test}} implemented in the package \code{rstatix}. The function first calculates cell population frequencies for each sample in sample_var. Then a Friedman Rank Sum test is performed for each cell population followed by p-value adjustment. If \code{post_hoc = T}, post-hoc testing with pairwise Wilcoxon Rank Sum Tests and p-value correction is performed for each significant Friedman Rank Sum test comparison.
}
