% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_testing.R
\name{frequency_t_test}
\alias{frequency_t_test}
\title{t-test to compare cell population frequencies}
\usage{
frequency_t_test(
  fcd,
  cluster_slot,
  cluster_var,
  sample_var,
  group_var,
  pair_var = NULL,
  paired_test = F,
  var.equal = F,
  detailed = F,
  p.adjust.method = "bonferroni",
  numeric = F,
  print_results = T
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{sample_var}{string indicating variable in cell_anno that defines sample IDs to be used.}

\item{group_var}{string indicating variable in cell_anno that should be used to group samples in sample_var. group_var must have exactly two levels.}

\item{pair_var}{string indicating variable in cell_anno that defines pairing of samples, e.g. donor ID, that should be used if \code{paired_test = T}.}

\item{paired_test}{logical, indicating if a paired (TRUE) or unpaired test (FALSE, default) should be performed.}

\item{var.equal}{logical, indicating whether variance in both groups should be treated as equal (TRUE) or not (FALSE, default). TRUE uses pooled variance, FALSE the Welch approximation, see documentation of \code{\link[rstatix]{t_test}} .}

\item{detailed}{logical if detailed output from \code{\link[rstatix]{t_test}} should be reported.}

\item{p.adjust.method}{p-value adjustment method to use for multiple comparison testing, e.g "bonferroni" (default) or "BH" (Benjamini-Hochberg). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{numeric}{logical, if TRUE numeric levels in cluster_var are ordered in ascending order and "Cluster_" is pasted before number, if FALSE alphabetical ordering is applied.}

\item{print_results}{Logical, indicating if the test results are printed to the console (TRUE) or not (FALSE).}
}
\value{
\code{frequency_t_test()} returns the fcd containing a data frame produced by \code{\link[rstatix]{t_test}} with two additional columns, "cluster" containing the information, which cell population was tested, and "applied_test", indicating which test was used. Results are stored in the fcd under extras$statistics.
}
\description{
\code{frequency_t_test()} performs a two-sided, two sample t-test on cell type frequencies.
}
\details{
frequency_t_test

\code{frequency_t_test()} is a wrapper function around the \code{t_test()} implemented in the package \code{rstatix}.
The function first calculates cell population frequencies for each sample in sample_var. Then, a two-sided, two sample t-test is performed between two groups defined in group_var.
The test can either be run unpaired (two independent groups) or paired. Afterwards,  p-value adjustment will be performed across all comparisons that were made.
}
