% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{getTable}
\alias{getTable}
\title{Get summary values}
\usage{
getTable(
  fcd,
  output_type = "frequency",
  expr_slot = "orig",
  cluster_slot,
  cluster_var,
  group_var,
  numeric = F
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{output_type}{type of parameter that should be reported in table. One of the following option needs to be selected:
\itemize{
 \item{"counts"} : gives cell numbers per group_var and cell population
 \item{"frequency"} : returns proportion of each cell population for each level in group_var (default)
 \item{"median"}: calculates median expression for each group_var and cell population combination for each available feature in expression matrix
 \item{"mean"}: calculates mean expression for each group_var and cell population combination for each available feature in expression matrix
}}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{group_var}{string indicating variable name in cell_anno that should be used to group the output, e.g. group or sample ID.}

\item{numeric}{logical, if TRUE numeric levels in cluster_var are ordered in increasing order and "Cluster_" is pasted before number, if FALSE alphabetical ordering is applied.}
}
\value{
\code{getTable()} returns a data frame with parameters in columns and observations in rows. In case of output_type of "counts" or "frequency", counts and frequencies for each cell population (columns) are reported in one row for each level in group_var. Given an output_type of "mean" or "median", aggregated expression for each feature (columns) is reported for each group_var and cell population combination (cluster).
}
\description{
\code{getTable()} can be used to generate frequently used parameters on cell populations defined by clustering or prediction, while considering a meta variable for grouping. It can produce cell numbers (counts), cell population frequencies as well as median or mean marker expression for each group to cell population combination.
}
\details{
getTable
}
