% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_correction.R
\name{harmonize_intensities}
\alias{harmonize_intensities}
\title{harmonize_intensities}
\usage{
harmonize_intensities(fcd, batch_var, seed = 91)
}
\arguments{
\item{fcd}{flow cytometry dataset.}

\item{batch_var}{vector of column names from \code{fcd$anno$cell_anno} to use for correcting the data.}

\item{seed}{A seed is set for reproducibility.}
}
\value{
The function returns a fcd with a harmonized expression data frame based on \code{\link[harmony]{HarmonyMatrix}}. The harmonized expression data frame is saved in \code{fcd$expr$norm}.
}
\description{
Harmonize the expression values for a defined batch variable (\code{batch_var}).
}
\details{
harmonize_intensities


See [Korunsky et al., 2019](https://doi.org/10.1038/s41592-019-0619-0) for more details on the Harmony algorithm.
}
