% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_confusion_HM}
\alias{plot_confusion_HM}
\title{plot_confusion_HM}
\usage{
plot_confusion_HM(
  fcd,
  cluster_slot,
  cluster_var,
  group_var,
  numeric = FALSE,
  size = 15,
  title = "Confusion matrix",
  cluster_cols = FALSE,
  cluster_rows = FALSE
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used to calculate the confusion.}

\item{group_var}{string indicating variable name in cell_anno that should be used to calculate the relative contribution to the variable specified in cluster_var.}

\item{numeric}{logical, indicating if levels in cluster_var should be ordered in ascending numerical order.}

\item{size}{size of the individual squares and font}

\item{title}{character string, title of the plot.}

\item{cluster_cols}{logical indicating if columns should be clustered (default: FALSE)}

\item{cluster_rows}{logical indicating if rows should be clustered (default: FALSE)}
}
\value{
\code{plot_confusion_HM()} first calculates cell counts for each combination of group_var and cell population and normalizes the counts to a total of 1000 cells per group_var.
Afterwards the percentage of cells coming from each level in group_var is calculated per cell population. The normalization of counts corrects the visualization for differences in total cells (events) measured per group_var.
}
\description{
\code{plot_confusion_HM()} generates a heatmap showing the contribution of each group_var to a cell population after normalizing all levels in group_var to the same cell numbers.
}
\details{
plot_confusion_HM
}
