% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_dim_density}
\alias{plot_dim_density}
\title{dimensionality reduction plot with density distribution}
\usage{
plot_dim_density(
  fcd,
  reduction_method = "umap",
  reduction_slot,
  group_var,
  title = "",
  dot_size = 0.1,
  alpha = 0.2,
  color_density = c("Blues", "Oranges", "Reds")
)
}
\arguments{
\item{fcd}{flow cytometry data set comprising dimensionality reduction calculated with cyCONDOR.}

\item{reduction_method}{string specifying which dimensionality reduction method to use. At the moment, only "umap" is supported.}

\item{reduction_slot}{string specifying reduction name in reduction_method to use for visualization, e.g. "pca_orig".}

\item{group_var}{string indicating variable name in cell_anno for which density distribution will be plotted for each level in group_var.}

\item{title}{character string, title of the plot}

\item{dot_size}{size of the background dots.}

\item{alpha}{transparency of the background dots.}

\item{color_density}{vector of strings indicating the color palette from \code{RColorBrewer} to be used for the density gradient. A names vector using levels in group_var allows the assignment of a specific color to a group level. If vector is not names, entries will be assigned to groups in alphabetic order and color palettes will be reused if vector has less colors than levels in group_var}
}
\value{
Density Plot
}
\description{
\code{plot_dim_density()} plots the density distribution of each level of a grouping variable on top of dimensionality reduction plot. At the moment, only UMAP visualization is supported
}
\details{
plot_dim_density
}
