% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_frequency_barplot}
\alias{plot_frequency_barplot}
\title{bar chart of cell population frequencies}
\usage{
plot_frequency_barplot(
  fcd = condor,
  cluster_slot,
  cluster_var,
  group_var,
  facet_var = NULL,
  color_palette = cluster_palette,
  title = "Frequency"
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var.}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{group_var}{string indicating variable name in cell_anno that defines grouping variable to be used (x-axis), e.g. group or sample ID.}

\item{facet_var}{(optional) string indicating variable name in cell_anno that should be used to group levels in group_var via faceting.}

\item{color_palette}{vector of colors to be used to fill bar chart plots}

\item{title}{title of the plot, default is "Frequency"}
}
\value{
\code{plot_frequency_barplot} returns a plot showing cell population frequencies for each level in group_var. The plot is faceted by another variable, when provided a facet_var.
}
\description{
\code{plot_frequency_barplot()} plots cell population frequencies for each level in group_var as stacked barplot.
}
\details{
plot_frequency_barplot
}
