% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_density}
\alias{plot_marker_density}
\title{density plot of marker expression in cell populations grouped by a meta variable}
\usage{
plot_marker_density(
  fcd,
  marker,
  expr_slot = "orig",
  cluster_slot,
  cluster_var,
  cluster_to_show = NULL,
  group_var,
  facet_var = NULL,
  facet_ncol = 5,
  color_palette = cluster_palette
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{marker}{vector of characters indicating which features of the expression matrix should be plotted.}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{cluster_to_show}{(optional) vector of strings indicating levels in cluster_var that should be included for plotting.}

\item{group_var}{string indicating variable name in cell_anno for which density distributions get calculated.}

\item{facet_var}{(optional) string indicating variable name in cell_anno that should be used to facet the plots by a meta variable.}

\item{facet_ncol}{numeric, number of columns used for faceting.}

\item{color_palette}{vector of colors to be used to color the density lines}
}
\value{
\code{plot_marker_density()} returns either one plot in case only one marker is provided via \code{marker} argument or a list of plots, if several markers are requested.
}
\description{
\code{plot_marker_density()} plots the density distribution of expression for cell populations. Each line indicates distribution for one level in group_var.
}
\details{
plot_marker_density

The density plots are plotted with default parameters of ggplot2's \code{\link[ggplot2]{geom_density}}.
}
