% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_dotplot}
\alias{plot_marker_dotplot}
\title{plot_marker_dotplot}
\usage{
plot_marker_dotplot(
  fcd,
  expr_slot = "orig",
  marker_x,
  marker_y,
  cluster_slot,
  cluster_var,
  cluster_to_show = NULL,
  group_var = NULL,
  order = F,
  seed = 91,
  color_palette = cluster_palette,
  dot_size = 2,
  alpha = 1,
  title = ""
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{marker_x}{marker name in expr slot of which transformed expression is shown on x-axis.}

\item{marker_y}{marker name in expr slot of which transformed expression is shown on y-axis.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var.}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{cluster_to_show}{(optional) vector of characters indicating levels in cluster_var that should be included for plotting.
By default all groups are plotted.}

\item{group_var}{(optional) string indicating variable name in cell_anno that should be used to color dots in plot. If not used, dots are clustered by cluster_var.}

\item{order}{logical if you want to order the dots in the plot by the variable used for coloring (TRUE). If set to FALSE (default), order of the cells is randomized.}

\item{seed}{a seed is set for reproducibility of the plotting result.}

\item{color_palette}{vector of colors that should be used to color dots.}

\item{dot_size}{numeric indicating the size of the dots.}

\item{alpha}{transparency of the dots.}

\item{title}{Title of the plot.}
}
\value{
The function returns a scatter plot of two features available in the expression matrix. By default, dots are colored by cell population label provided in cluster_var. If coloring by a metadata is wanted instead, a group_var can be defined. Further, if only a selection of levels available in cluster_var should be included in plotting, a vector of labels of interest can be provided to cluster_to_show argument.
}
\description{
\code{plot_marker_dotplot()} generates a classical scatter plot of two markers
}
\details{
plot_marker_dotplot
}
