% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_group_HM}
\alias{plot_marker_group_HM}
\title{Heatmap of scaled expression to compare two groups}
\usage{
plot_marker_group_HM(
  fcd,
  expr_slot = "orig",
  marker_to_exclude = NULL,
  cluster_slot,
  cluster_var,
  group_var,
  maxvalue = NULL,
  size = 10,
  title = "Heatmap of scaled expression"
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{marker_to_exclude}{(optional) vector of characters indicating which features in expression matrix should not be included in the heatmap.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{group_var}{string indicating variable name in cell_anno that should be used for subgrouping each cell population.}

\item{maxvalue}{max value for the coloring (default: NULL, automatically defined).}

\item{size}{size of the individual squares and font.}

\item{title}{character string, title of the plot}
}
\value{
A heatmap of scaled mean expression, depicting markers in rows and cell populations grouped by a grouping variable in columns.
}
\description{
\code{plot_marker_group_HM()} generates a heatmap of scaled mean marker expression for each cell population split by a grouping variable.
}
\details{
plot_marker_group_HM
}
