% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_load_and_transform.R
\name{prep_fcd}
\alias{prep_fcd}
\title{prep_fcd}
\usage{
prep_fcd(
  data_path,
  max_cell,
  useCSV = FALSE,
  transformation = NULL,
  remove_param = NULL,
  anno_table,
  filename_col,
  seed = 91,
  separator_anno = ",",
  separator_fc_csv = ",",
  simple_names = TRUE,
  truncate_max_range = FALSE,
  emptyValue = TRUE,
  ignore.text.offset = FALSE,
  verbose = FALSE,
  cross_path_with_anno = FALSE,
  cofactor = 5
)
}
\arguments{
\item{data_path}{Folder where the .fcs files or .csv files are stored.}

\item{max_cell}{Number of cells to use for each file (set to a high number if you want to use all available events).}

\item{useCSV}{Flag if the input are .csv files and not .fcs (experimental).}

\item{transformation}{Transformation to perform. Select one of the following: \code{"auto_logi"} (autologicle, recommended for flow cytometry data), \code{"arcsinh"} (arcsinh transformation with cofactor 5), \code{"clr"} (centered-log-ratio) or \code{"none"} (no transformation).}

\item{remove_param}{Parameters to be removed from the \code{fcd}, "inTime" should be kept.}

\item{anno_table}{Path to the annotation table text file. The annotation table should contain one column with the file names of all .fcs or .csv files to read in and optionally additional columns with further sample information (e.g. "sample_id", "condition").}

\item{filename_col}{Name of the column of the \code{anno_table} containing the file name matching with the .fcs/.csv files.}

\item{seed}{A seed is set for reproducibility.}

\item{separator_anno}{Separator used in the annotation file, by default \code{separator_anno = ","}.}

\item{separator_fc_csv}{Separator used in the cytometry data .csv files, by default \code{separator_anno = ","}.}

\item{simple_names}{If TRUE only the channel description is used to name the column, if FALSE both channel name and description are pasted together.}

\item{truncate_max_range}{From FlowCore: logical type. Default is FALSE. can be optionally turned off to avoid truncating the extreme positive value to the instrument measurement range .i.e.'$PnR'.}

\item{emptyValue}{From FlowCore: boolean indicating whether or not we allow empty value for keyword values in TEXT segment. It affects how the double delimiters are treated. IF TRUE, The double delimiters are parsed as a pair of start and end single delimiter for an empty value. Otherwise, double delimiters are parsed one part of string as the keyword value. default is TRUE.}

\item{ignore.text.offset}{From FlowCore: whether to ignore the keyword values in TEXT segment when they don't agree with the HEADER. Default is FALSE, which throws the error when such discrepancy is found. User can turn it on to ignore TEXT segment when he is sure of the accuracy of HEADER so that the file still can be read.}

\item{verbose}{Default FALSE, if TRUE the at each file loaded something is printed in the screen.}

\item{cross_path_with_anno}{Defautl FALSE. If TRUE is the 'data_path' contains more files then the annotation table only the overlap will be loaded.}

\item{cofactor}{cofactor used for 'arcsinh' transformation, default 5, can be set to 150 for HDFC data.}
}
\value{
An object of class 'flow cytometry dataframe' (\code{fcd}) is returned.

prep_fcd
}
\description{
Loading and transforming the data to create a flow cytometry dataset from FCS files for the analysis with the cyCONDOR workflow.
}
\details{
prep_fcd

The \code{prep_fcd} is a wrapper function to read in the files, subset to \code{max_cell}, transform the data and create a 'flow cytometry dataframe' (\code{fcd}).
}
