% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample_geosketch.R
\name{subsample_geosketch}
\alias{subsample_geosketch}
\title{Subsampling base on geometric sketching}
\usage{
subsample_geosketch(condor, pca_slot = "orig", n_sub = 0.5)
}
\arguments{
\item{condor}{Flow cytometry dataset.}

\item{pca_slot}{PCA slot to use for the sketching (e.g. "orig" or "norm").}

\item{n_sub}{Number of cells to subset (default half of all cells).}
}
\value{
Returns a subsampled condor object
}
\description{
Subsamples the condor object to a predefined number of cells based on the geosketching algorithm (https://github.com/brianhie/geosketch).
Using the PCA representation it subsamples your dataset by preserving the overall structure. Important,
if you do not want to loose rare cell populations or do not want skew cell numbers. Requires the python package geosketch and reticulate.
}
