% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical_classifier.R
\name{train_classifier_model}
\alias{train_classifier_model}
\title{Train a machine learning classifier for the clinical classification of HDFC data.}
\usage{
train_classifier_model(
  fcd,
  input_type,
  data_slot,
  sample_names = "expfcs_filename",
  classification_variable,
  family = "binomial",
  type1 = "response",
  type2 = "response",
  parallelCore = 1,
  reg = FALSE,
  seed = 91
)
}
\arguments{
\item{fcd}{flow cytometry data set.}

\item{input_type}{data to use for the calculation, e.g. "expr" (suggested option).}

\item{data_slot}{Name of the data slot to use for the classification, suggested options are "orig" or "norm".}

\item{sample_names}{Column name of the metadata table containing the samples names.}

\item{classification_variable}{Vector (same length as number of cells) with the classes to classify (e.g. ctrl/dis).}

\item{family}{Response type. Must be one of the following: "gaussian","binomial","poisson","multinomial","cox","mgaussian".}

\item{type1}{Type of first level prediction. Type of prediction required. Type "link" gives the linear predictors for "binomial", "multinomial", "poisson" or "cox" models; for "gaussian" models it gives the fitted values. Type "response" gives the fitted probabilities for "binomial" or "multinomial", fitted mean for "poisson" and the fitted relative-risk for "cox"; for "gaussian" type "response" is equivalent to type "link".}

\item{type2}{Type of second level prediction.}

\item{parallelCore}{Number of cores to be used.}

\item{reg}{If elestic net regularization will be used (Default: FALSE).}

\item{seed}{A seed is set for reproducibility.}
}
\value{
train_classifier_model
}
\description{
This function trains a machine learning classifier for the clinical classification of HDFC data. This function uses the *CytoDx* framework.
}
\details{
Train Clinical Classifier

`train_classifier_model()` is a wrapper function around \code{\link[CytoDx]{CytoDx.fit}} implemented in the package *CytoDx*. 
The user can specify all the parameters available for the \code{\link[CytoDx]{CytoDx.fit}} functions, arguments description were copied from the documentation of the *CytoDx* package.
The function output a *condor* object including the machine learning model in the *extras* slot.
}
