% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_load_and_transform.R
\name{write_fcs}
\alias{write_fcs}
\title{Save the results from cyCONDOR as FCS file(s)}
\usage{
write_fcs(
  fcd = condor,
  expr_slot = "orig",
  reduction_method = NULL,
  reduction_slot = NULL,
  cluster_slot = NULL,
  cluster_var = NULL,
  split_by = NULL,
  dir = paste0(getwd(), "/"),
  filename
)
}
\arguments{
\item{fcd}{flow cytometry data set}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".}

\item{reduction_method}{string specifying which dimensionality reduction method to use.}

\item{reduction_slot}{string specifying reduction name in reduction_method to use for visualization, e.g. "pca_orig".}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var.}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels). Must be numeric in this function - factors are converted automatically.}

\item{split_by}{NULL or character string specifying a metadata variable (e.g. sample_ID) to split the data. If NULL, only one FCS file with all data is generated.}

\item{dir}{string specifying the directory where the FCS file(s) is/are saved. Current working directory by default.}

\item{filename}{string specifying the filename for the FCS file. If split_by is defined, an automatic suffix according to the defined variable is assigned to the FCS files.}
}
\value{
Message that FCS file(s) are saved in the defined directory.
}
\description{
Saves the expression data, annotation data and (optionally) results from the cyCONDOR analysis (dimensionality reduction, clustering) as one or more FCS file(s).
}
\details{
Save the results from cyCONDOR as FCS file(s)
}
