% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_plot_comparison.R
\name{corr_plot_comparison}
\alias{corr_plot_comparison}
\title{Sample-wise correlation of cell type proportions to compare manual gating and cyCONDOR.}
\usage{
corr_plot_comparison(
  condor_df,
  flowjo_df,
  sample_col,
  method_corr = "pearson",
  tl.cex = 1,
  cl.cex = 1
)
}
\arguments{
\item{condor_df}{data frame containing the cell type frequencies obtained via clustering and annotation in cyCONDOR.}

\item{flowjo_df}{data frame containing the cell type frequencies obtained via manual gating and annotation (e.g. FlowJo).}

\item{sample_col}{name of the column containing sample names. This column name needs to be matching between the two data frames.}

\item{method_corr}{correlation method used in the correlogram (default = "pearson").}

\item{tl.cex}{Numeric, for the size of text label (variable names).}

\item{cl.cex}{Numeric, text size of number-label in color-legend}
}
\description{
'corr_plot_comparison' performs a sample-wise correlation of cell type proportions obtained via manual gating and via clustering on cyCONDOR. The result is shown in a correlogram.
}
\details{
corr_plot_comparison
}
