% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_testing.R
\name{frequency_kruskal_test}
\alias{frequency_kruskal_test}
\title{Kruskal-Wallis test to compare cell population frequencies}
\usage{
frequency_kruskal_test(
  fcd,
  cluster_slot,
  cluster_var,
  sample_var,
  group_var,
  kruskal_p.adjust.method = "bonferroni",
  post_hoc_test = T,
  post_hoc_p.adjust.method = "bonferroni",
  kruskal_sig_threshold = 0.05,
  numeric = F,
  print_results = T
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{sample_var}{string indicating variable in cell_anno that defines sample IDs to be used.}

\item{group_var}{string indicating variable in cell_anno that should be used to group samples in sample_var. group_var must have three or more levels.}

\item{kruskal_p.adjust.method}{p-value adjustment method to use for multiple comparisons of Kruskal-Wallis test, e.g "bonferroni" (default) or "BH" (Benjamini-Hochberg). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{post_hoc_test}{logical, whether to perform post-hoc testing (TRUE, default) or not (FALSE).}

\item{post_hoc_p.adjust.method}{p-value adjustment method to use for post-hoc testing, e.g "bonferroni" (default). All available options can be checked in the documentation of the \code{\link[rstatix]{adjust_pvalue}} function from the package \code{rstatix}.}

\item{kruskal_sig_threshold}{significance threshold for Kruskal-Wallis test. For all Kruskal-Wallis comparisons with an adjusted p-value equal or smaller than the threshold, post-hoc tests are performed (default 0.05)}

\item{numeric}{logical, if TRUE numeric levels in cluster_var are ordered in ascending order and "Cluster_" is pasted before number, if FALSE alphabetical ordering is applied.}

\item{print_results}{Logical, indicating if the test results are printed to the console (TRUE) or not (FALSE).}
}
\value{
\code{frequency_kruskal_test()} returns the fcd conaining two data frames, "kruskal" and "kruskal_pht". "kruskal" comprises results produced by \code{\link[rstatix]{kruskal_test}} and \code{\link[rstatix]{kruskal_effsize}} and "kruskal_pht" contains results obtained by \code{\link[rstatix]{dunn_test}}. Both data frames have one additional columns, "cluster", containing the information, which cell population was tested. Results are stored in the fcd under extras$statistics.
}
\description{
\code{frequency_kruskal_test()} performs a Kruskal-Wallis Rank Sum test to compare cell population frequencies of three of more groups. Optionally, post-hoc testing is performed using Dunne's test.
}
\details{
frequency_kruskal_test

\code{frequency_kruskal_test()} is a wrapper function around \code{\link[rstatix]{kruskal_test}},  \code{\link[rstatix]{kruskal_effsize}} and  \code{\link[rstatix]{dunn_test}} implemented in the package *rstatix*. The function first calculates cell population frequencies for each sample in sample_var. Then a Kruskal-Wallis rank sum test is performed for each cell population followed by p-value adjustment. If \code{post_hoc = T}, post-hoc testing with Dunne's Test and p-value correction is performed for each significant Kruskal-Wallis comparison.
}
