% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_projection.R
\name{learnUMAP}
\alias{learnUMAP}
\title{learnUMAP}
\usage{
learnUMAP(
  fcd,
  input_type,
  data_slot,
  nPC = ncol(fcd[[input_type]][[data_slot]]),
  markers = colnames(fcd$expr[[data_slot]]),
  discard = FALSE,
  fcd_model,
  nEpochs = 100,
  prefix = NULL,
  nThreads = 32,
  seed = 91
)
}
\arguments{
\item{fcd}{Flow cytometry dataset for which the UMAP coordinates should be predicted.}

\item{input_type}{Data to use for the calculation of the UMAP, e.g. \code{expr} or \code{pca}. This should be the same which has been used for calculating the UMAP of the reference data set.}

\item{data_slot}{Name of the \code{input_type} data slot to use e.g. \code{orig}, if no prefix was added. This should be the same which has been used for calculating the UMAP of the reference data set.}

\item{nPC}{Number of PCs used for the UMAP Projection. Default = All. The number of PCs should be the same used for calculating the UMAP of the reference data set. Check the UMAP name of your reference data set e.g. using \code{fcd_model$umap$your_umap_name}.}

\item{markers}{Vector of marker names to include or exclude from UMAP projection according to the discard parameter. The markers should be the same used for calculating the UMAP of the reference data set. Use the function \code{\link{used_markers}} to check which markers were used to calculate the UMAP of your \code{fcd_model}.  .}

\item{discard}{LOGICAL to decide if the markers specified should be included, "F", or excluded, "T", from the UMAP projection. Default = F.}

\item{fcd_model}{Flow cytometry reference data set containing data associated with an existing embedding in \code{fcd_model$extras}.}

\item{nEpochs}{Number of epochs to use during the optimization of the embedded coordinates. A value between 30 - 100 is a reasonable trade off between speed and thoroughness. By default, this value is set to one third the number of epochs used to build the model.}

\item{prefix}{Prefix for the name of the dimensionality reduction.}

\item{nThreads}{Number of threads to use, (except during stochastic gradient descent). By default \code{nThreads = 32}.}

\item{seed}{A seed is set for reproducibility.}
}
\value{
\code{learnUMAP()} returns a \code{fcd} with the predicted UMAP coordinates saved in \code{fcd$umap$expr_orig}, if no \code{prefix} was set.
}
\description{
Projects new samples on a UMAP calculated previously for a reference data set with the same parameters as the new sample. Before executing this function, \code{\link{runUMAP}} needs to be run with \code{ret_model = TRUE} for the reference data set.
}
\details{
learnUMAP

\code{learnUMAP()} uses \code{\link[uwot]{umap_transform}} to project new samples contained in \code{fcd} on the embedding previously calculated in a reference data set, \code{fcd_model}, using \code{\link{runUMAP}}.
}
