% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_counts_barplot}
\alias{plot_counts_barplot}
\title{bar chart of cell population counts}
\usage{
plot_counts_barplot(
  fcd = condor,
  cluster_slot,
  cluster_var,
  group_var,
  facet_var = NULL,
  facet_by_clustering = F,
  facet_ncol = NULL,
  color_palette = cluster_palette,
  title = "Counts"
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{group_var}{string indicating variable name in cell_anno that defines grouping variable to be used (x-axis), e.g. group or sample ID.}

\item{facet_var}{(optional) string indicating variable name in cell_anno that should be used to group levels in group_var via faceting.}

\item{facet_by_clustering}{logical, if set to TRUE, the plot will be faceted by cell populations specified in cluster_var. If set to FALSE not faceting by population will be applied (default). If both, facet_var and facet_by_clustering are used plot will be faceted by both using applying facet_grid.}

\item{facet_ncol}{numeric, indicating how many columns faceted plot should have, if either facet_var or Facet_by_clustering is used.}

\item{color_palette}{vector of colors to be used to fill bar chart plots}

\item{title}{title of the plot, default is "Counts"}
}
\value{
\code{plot_counts_barplot()} returns a plot showing cell numbers per cell population for each level in group_var. The plot is faceted by another variable, when provided a facet_var and or by the cell population, depending on facet_by_clustering.
}
\description{
\code{plot_counts_barplot()} plots cell population counts for each level in group_var as bar plot.
}
\details{
plot_counts_barplot
}
