% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_frequency_boxplot}
\alias{plot_frequency_boxplot}
\title{box plot of cell population frequencies}
\usage{
plot_frequency_boxplot(
  fcd,
  cluster_slot,
  cluster_var,
  sample_var,
  group_var,
  groups_to_show = NULL,
  numeric = F,
  color_palette = cluster_palette,
  dot_size = 2,
  statistics = F,
  sig_label = "p.adj.signif"
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{sample_var}{string indicating variable name in cell_anno that defines sample IDs to be used.}

\item{group_var}{string indicating variable name in cell_anno that should be used to group samples in sample_var}

\item{groups_to_show}{vector of strings indicating levels in group_var that should be included for plotting. By default all groups are plotted.}

\item{numeric}{logical, if TRUE numeric levels in cluster_var are ordered in increasing order and "Cluster_" is pasted before number, if FALSE alphabetical ordering is applied.}

\item{color_palette}{vector of colors to be used to fill box plots}

\item{dot_size}{Size of the dots.}

\item{statistics}{optional string indicating if and which statistics are displayed in the plot. Currently, "wilcox", "t_test" or "diffcyt" are accepted as input. If no statistics should be displayed, set to FALSE.}

\item{sig_label}{string indicating how the significance is indicated: "p.adj" for the numerical adjusted p-value, "p.adj.signif" for asteriks.}
}
\value{
\code{plot_frequency_boxplots()} returns a list of boxplots, each element of the list contains the plot of one cell population.
}
\description{
\code{plot_frequency_boxplot()} plots cell population frequencies of samples grouped by group_var as boxplots.
}
\details{
plot_frequency_boxplot
}
