% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_HM}
\alias{plot_marker_HM}
\title{Heatmap of scaled expression by cell population}
\usage{
plot_marker_HM(
  fcd,
  expr_slot = "orig",
  marker_to_exclude = NULL,
  cluster_slot,
  cluster_var,
  cluster_rows = FALSE,
  cluster_cols = FALSE,
  maxvalue = NULL,
  size = 10,
  title = "Heatmap of scaled expression"
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{marker_to_exclude}{(optional) vector of characters indicating which features in expression matrix should not be included in the heatmap.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{cluster_rows}{logical indicating if heatmap rows should be clustered (default: FALSE).}

\item{cluster_cols}{logical indicating if heatmap columns should be clustered (default: FALSE).}

\item{maxvalue}{max value for the coloring (default: NULL, automatically defined).}

\item{size}{size of the individual squares and font.}

\item{title}{character string, title of the plot}
}
\value{
A heatmap of scaled mean expression, depicting markers in rows and cell populations in columns.
}
\description{
\code{plot_marker_HM()} generates a heatmap of scaled mean marker expression for each cell population.
}
\details{
plot_marker_HM
}
