% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_boxplot}
\alias{plot_marker_boxplot}
\title{plot box plots of marker median or mean}
\usage{
plot_marker_boxplot(
  fcd,
  marker = NULL,
  expr_slot = "orig",
  cluster_slot = "Phenograph_pca_orig_k_60",
  cluster_var = "metaclusters",
  cluster_to_show = NULL,
  group_var,
  sample_var,
  fun = "median",
  facet_by_clustering = F,
  facet_ncol = 5,
  color_palette = cluster_palette,
  dot_size = 2
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{marker}{marker in provided expr_slot that should be included in plotting. By default all features are plotted.}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{cluster_to_show}{vector of characters indicating levels in cluster_var that should be included for plotting.
By default all groups are plotted.}

\item{group_var}{string indicating variable name in cell_anno that should be used to group samples in sample_var}

\item{sample_var}{string indicating variable name in cell_anno that defines sample IDs to be used.}

\item{fun}{string indicating which aggregation of expression should be performed for each sample. Needs to be one out of "median" (default) or "mean".}

\item{facet_by_clustering}{logical indicating how to structure faceting of the plot. If set to FALSE (default) plot will be faceted by markers and clusters (or cell populations) are shown on x-axis. If set to TRUE, it is the other way around.}

\item{facet_ncol}{Number of columns to be used for faceting.}

\item{color_palette}{vector of colors that should be used to fill box plots.}

\item{dot_size}{numeric indicating the size of the dots.}
}
\value{
A faceted ggplot showing box plots of aggregated expression per sample grouped by group_var.
}
\description{
\code{plot_marker_boxplot()} generates faceted box plots of aggregated expression per sample grouped by a grouping of interest for each marker-cluster combination.
}
\details{
plot_marker_boxplot
}
