% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_ridgeplot}
\alias{plot_marker_ridgeplot}
\title{ridgeline plot of marker expression in cell populations}
\usage{
plot_marker_ridgeplot(
  fcd,
  marker,
  expr_slot = "orig",
  cluster_slot,
  cluster_var,
  cluster_to_show = NULL,
  color_palette = rev(cluster_palette),
  alpha = 1,
  title = ""
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{marker}{vector of characters indicating which features of the expression matrix should be plotted.}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{cluster_to_show}{(optional) vector of strings indicating levels in cluster_var that should be included for plotting.}

\item{color_palette}{vector of colors to be used to fill density distributions.}

\item{alpha}{numeric, adjust alpha to be used on fill color of density distributions.}

\item{title}{Title of the plot.}
}
\value{
\code{plot_marker_ridgeplot()} returns either one plot in case only one marker is provided via \code{marker} argument or a list of plots, if several markers are requested.
}
\description{
\code{plot_marker_ridgeplot()} plots the expression of selected markers as ridgeline plots for cell populations.
}
\details{
plot_marker_ridgeplot

The ridgeline plots are plotted with default parameters of ggridges's \code{\link[ggridges]{geom_density_ridges}}
}
