% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_marker_violinplot}
\alias{plot_marker_violinplot}
\title{violin plot of marker expression in cell populations}
\usage{
plot_marker_violinplot(
  fcd,
  marker,
  expr_slot = "orig",
  cluster_slot,
  cluster_var,
  cluster_to_show = NULL,
  group_var = NULL,
  color_palette = cluster_palette
)
}
\arguments{
\item{fcd}{flow cytometry data set, that has been subjected to clustering or cell type label prediction with cyCONDOR}

\item{marker}{vector of characters indicating which features of the expression matrix should be plotted.}

\item{expr_slot}{expr_slot from which to take marker expression values, default is "orig".
Corrected input data should be handled cautiously.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{cluster_to_show}{vector of strings indicating levels in cluster_var that should be included for plotting.}

\item{group_var}{(optional) string indicating variable name in cell_anno that should be used to split violin plots.}

\item{color_palette}{vector of colors to be used to fill violin plots, when group_var is used}
}
\value{
\code{plot_marker_violinplot()} returns either one plot in case only one marker is provided via \code{marker} argument or a list of plots, if several markers are requested.
}
\description{
\code{plot_marker_violinplot()} plots the expression of selected markers as violin plots for cell populations.
}
\details{
plot_marker_violinplot

The violin plots are plotted with default parameters of ggplot2's \code{\link[ggplot2]{geom_violin}} and horizontal lines indicate the median.
}
