% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_load_and_transform.R
\name{prep_fjw}
\alias{prep_fjw}
\title{Read FlowJo Workspace}
\usage{
prep_fjw(
  data_gs,
  inverse.transform = FALSE,
  transformation = NULL,
  remove_param = NULL,
  merge_anno = FALSE,
  anno_table = NULL,
  separator_anno = ",",
  filename_col = NULL
)
}
\arguments{
\item{data_gs}{Gate Set object, e.g. created by using \code{\link[CytoML]{open_flowjo_xml}} and \code{\link[CytoML]{flowjo_to_gatingset}} from the CytoML package.}

\item{inverse.transform}{Logical: if the data should be reverse transformed or kept with FlowJo transformation (default = FALSE).}

\item{transformation}{If \code{inverse.transform = TRUE}, type of new transformation to perform. Select one of the following: \code{"auto_log"} (autologicle, recommended for flow cytometry data), \code{"arcsinh"} (arcsinh transformation), \code{"clr"} (centered-log-ratio) or \code{"none"} (no transformation).}

\item{remove_param}{Parameters to be removed from the \code{fcd}.}

\item{merge_anno}{Logical: If sample anno should be merged to the \code{fcd}.}

\item{anno_table}{If \code{merge_anno = TRUE}, path to the annotation table text file. The annotation table should contain one column with the file names of all .fcs or .csv files to read in and optionally additional columns with further sample information (e.g. "sample_id", "condition").}

\item{separator_anno}{Separator used in the annotation file, by default \code{separator_anno = ","}.}

\item{filename_col}{Name of the column of the \code{anno_table} containing the file name matching with the .fcs files.}
}
\value{
An object of class 'flow cytometry dataframe' (\code{fcd}) is returned.

read_flowjo_workspace
}
\description{
Loading and transforming the data to create a flow cytometry dataset from a Gate Set object for the analysis with the cyCONDOR workflow.

\code{prep_fjw} takes a gate set object as input and returns a \code{fcd} with the FlowJo gating information saved in \code{fcd$anno$cell_anno}.
}
\details{
Read FlowJo workspace
}
