% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astir.R
\name{runAstir_cellstates}
\alias{runAstir_cellstates}
\title{runAstir_cellstates}
\usage{
runAstir_cellstates(
  fcd,
  data_slot,
  analysis_path,
  manifest_name,
  max_epochs,
  learning_rate,
  initial_epochs,
  prefix = NULL
)
}
\arguments{
\item{fcd}{Flow cytometry dataset.}

\item{data_slot}{Data slot to use for the analysis (e.g. "orig" or "norm").}

\item{analysis_path}{Full path to the output folder of astir analysis.}

\item{manifest_name}{Filename of the manifest file, this file must be located in the `analysis_path` folder.}

\item{max_epochs}{Maximum number of epochs.}

\item{learning_rate}{Learning Rate.}

\item{initial_epochs}{Initial Epochs.}

\item{prefix}{Optional prefix for the slot name of the output.}
}
\value{
runAstir_cellstates
}
\description{
Predict cell states using Astir. This package requires the python library `astir` and `reticulate` to work.
The function returns a `condor` object with automatically annotated cell states and QC of the annotation, the results are also saved in a folder specified by the user.
}
\details{
Run Astir cell state prediction
}
