% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{runFlowSOM}
\alias{runFlowSOM}
\title{runFlowSOM}
\usage{
runFlowSOM(
  fcd,
  input_type,
  data_slot,
  nClusters,
  grid_xdim = 10,
  grid_ydim = 10,
  seed = 91,
  prefix = NULL,
  ret_model = FALSE,
  nPC = ncol(fcd[[input_type]][[data_slot]]),
  markers = colnames(fcd$expr[[data_slot]]),
  discard = FALSE
)
}
\arguments{
\item{fcd}{flow cytometry dataset.}

\item{input_type}{data to use for the calculation, e.g. "expr" or "pca".}

\item{data_slot}{data slot to use for the calculation, e.g. "orig" or "norm".}

\item{nClusters}{Number of final clusters.}

\item{grid_xdim}{x-axis size of the FlowSOM grid. Default = 10.}

\item{grid_ydim}{y-axis size of the FlowSOM grid. Default = 10.}

\item{seed}{A seed is set for reproducibility.}

\item{prefix}{Optional prefix for the slot name of the output.}

\item{ret_model}{LOGICAL if the model should be saved for future projection of the data. Default = F.}

\item{nPC}{Number of principal components to use for the analysis. Default = All.}

\item{markers}{vector of marker names to include or exclude from the calculation according to the discard parameter. See functions used_markers and measured_markers for the extraction of markers directly from the condor object}

\item{discard}{LOGICAL if the markers specified should be included, "F", or excluded, "T", from the calculation. Default = F.}
}
\value{
The function returns a fcd including a data frame containing the FlowSOM clustering saved in \code{fcd$clustering}. The name of the output consists of the prefix (if given) and the data slot and the defined \code{nClusters}. If a \code{nPC} is given it will be added to the output name.
}
\description{
Run FlowSOM based clustering.
}
\details{
runFlowSOM


See [Van Gassen S et al. (2015) "FlowSOM: Using self-organizing maps for visualization and interpretation of cytometry data." Cytom Part J Int Soc Anal Cytol 87: 636-645.] (https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.22625)
}
