% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{runPhenograph}
\alias{runPhenograph}
\title{runPhenograph}
\usage{
runPhenograph(
  fcd,
  input_type,
  data_slot,
  k,
  seed = 91,
  prefix = NULL,
  nPC = ncol(fcd$pca[[data_slot]]),
  markers = colnames(fcd$expr[[data_slot]]),
  discard = FALSE
)
}
\arguments{
\item{fcd}{flow cytometry dataset.}

\item{input_type}{data to use for the calculation, e.g. "expr" or "pca" (suggested: "pca").}

\item{data_slot}{data slot to use for the calculation, e.g. "orig" or "norm".}

\item{k}{K value used for clustering.}

\item{seed}{A seed is set for reproducibility.}

\item{prefix}{Optional prefix for the slot name of the output.}

\item{nPC}{Number of principal components to use for the analysis.}

\item{markers}{vector of marker names to include or exclude from the calculation according to the discard parameter. See functions used_markers and measured_markers for the extraction of markers directly from the condor object}

\item{discard}{LOGICAL if the markers specified should be included, "F", or excluded, "T", from the calculation. Default = F.}
}
\value{
The function returns a fcd including a data frame containing the phenograph clustering saved in \code{fcd$clustering}. The name of the output consists of the prefix (if given) and the data slot and the defined \code{k}. If a \code{nPC} is given it will be added to the output name.
}
\description{
Run Phenograph based clustering.
}
\details{
runPhenograph


See [Stuchly J (2020). "Rphenoannoy: R implementation of the phenograph algorithm - approximate KNN modification, based on Rphenograph package". R package version 0.1.0.] (https://github.com/stuchly/Rphenoannoy)
}
