% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudotime.R
\name{runPseudotime}
\alias{runPseudotime}
\title{Function of calculate Pseudotime from HDFC data analysed with cyCONDOR}
\usage{
runPseudotime(
  fcd,
  reduction_method,
  reduction_slot,
  cluster_slot,
  cluster_var,
  start.clus = NULL,
  end.clus = NULL,
  dist.method = "slingshot",
  use.median = FALSE,
  omega = FALSE,
  omega_scale = 1.5,
  times = NULL,
  shrink = TRUE,
  extend = "y",
  reweight = TRUE,
  reassign = TRUE,
  thresh = 0.001,
  maxit = 15,
  stretch = 2,
  approx_points = NULL,
  smoother = "smooth.spline",
  shrink.method = "cosine",
  allow.breaks = TRUE,
  prefix = NULL,
  seed = 91
)
}
\arguments{
\item{fcd}{flow cytometry dataset.}

\item{reduction_method}{Type of dimensionality reduction to calculate the pseudotime.}

\item{reduction_slot}{Name of the dimensionality reduction slot to be used.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in cluster_var.}

\item{cluster_var}{string specifying variable name in cluster_slot that identifies cell population labels to be used (e.g. clusters, metaclusters or predicted labels).}

\item{start.clus}{(optional) character, indicates the starting cluster(s) from which lineages will be drawn.}

\item{end.clus}{(optional) character, indicates which cluster(s) will be forced to be leaf nodes in the graph.}

\item{dist.method}{(optional) character, specifies the method for calculating distances between clusters. Default is "slingshot", see createClusterMST for details.}

\item{use.median}{logical, whether to use the median (instead of mean) when calculating cluster centroid coordinates.}

\item{omega}{(optional) numeric or logical, this granularity parameter determines the distance between every real cluster and the artificial cluster, .OMEGA. In practice, this makes omega the maximum allowable distance between two connected clusters. By default, omega = Inf. If omega = TRUE, the maximum edge length will be set to the median edge length of the unsupervised MST times a scaling factor (omega_scale, default = 1.5). This value is provided as a potentially useful rule of thumb for datasets with outlying clusters or multiple, distinct trajectories. See outgroup in createClusterMST.}

\item{omega_scale}{(optional) numeric, scaling factor to use when omega = TRUE. The maximum edge length will be set to the median edge length of the unsupervised MST times omega_scale (default = 3). See outscale in createClusterMST.}

\item{times}{numeric, vector of external times associated with either clusters or cells. See defineMSTPaths for details.}

\item{shrink}{logical or numeric between 0 and 1, determines whether and how much to shrink branching lineages toward their average prior to the split (default = TRUE).}

\item{extend}{character, how to handle root and leaf clusters of lineages when constructing the initial, piece-wise linear curve. Accepted values are 'y' (default), 'n', and 'pc1'. See 'Details' for more.}

\item{reweight}{logical, whether to allow cells shared between lineages to be reweighted during curve fitting. If TRUE (default), cells shared between lineages will be iteratively reweighted based on the quantiles of their projection distances to each curve. See 'Details' for more.}

\item{reassign}{logical, whether to reassign cells to lineages at each iteration. If TRUE (default), cells will be added to a lineage when their projection distance to the curve is less than the median distance for all cells currently assigned to the lineage. Additionally, shared cells will be removed from a lineage if their projection distance to the curve is above the 90th percentile and their weight along the curve is less than 0.1.}

\item{thresh}{numeric, determines the convergence criterion. Percent change in the total distance from cells to their projections along curves must be less than thresh. Default is 0.001, similar to principal_curve.}

\item{maxit}{numeric, maximum number of iterations (default = 15), see principal_curve.}

\item{stretch}{numeric factor by which curves can be extrapolated beyond endpoints. Default is 2, see principal_curve.}

\item{approx_points}{numeric, whether curves should be approximated by a fixed number of points. If FALSE (or 0), no approximation will be performed and curves will contain as many points as the input data. If numeric, curves will be approximated by this number of points (default = 150 or #cells, whichever is smaller). See 'Details' and principal_curve for more.}

\item{smoother}{choice of scatter plot smoother. Same as principal_curve, but "lowess" option is replaced with "loess" for additional flexibility.}

\item{shrink.method}{character denoting how to determine the appropriate amount of shrinkage for a branching lineage. Accepted values are the same as for kernel in density (default is "cosine"), as well as "tricube" and "density". See 'Details' for more.}

\item{allow.breaks}{logical, determines whether curves that branch very close to the origin should be allowed to have different starting points.}

\item{prefix}{Optional prefix for the slot name of the output.}

\item{seed}{A seed is set for reproducibility.}
}
\value{
runPseudotime
}
\description{
Function of calculate Pseudotime from HDFC data analysed with cyCONDOR. This function uses *slingshot* to calculate trajectories and pesudotime for each cell in the 'condor' object.
}
\details{
runPseudotime

`runPseudotime()` is a wrapper function around \code{\link[slingshot]{getLineages}} and \code{\link[slingshot]{getCurves}} implemented in the package *slingshot*.
The function first calculated the linages and then the curves of the pseudotime and converts the result to a format compatible with the structure of the 'condor' object. The user can specify all the parameters available for the \code{\link[slingshot]{getLineages}} and  \code{\link[slingshot]{getCurves}} functions, arguments description were copied from the documentation of the *slingshot* package.
}
