% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_projection.R
\name{train_transfer_model}
\alias{train_transfer_model}
\title{train_transfer_model}
\usage{
train_transfer_model(
  fcd,
  input_type,
  data_slot,
  cluster_slot,
  cluster_var,
  method = "knn",
  tuneLength = 5,
  trControl = caret::trainControl(method = "cv"),
  seed = 91
)
}
\arguments{
\item{fcd}{flow cytometry dataset.}

\item{input_type}{Data to use for the calculation of the UMAP, e.g. \code{expr} or \code{pca}.}

\item{data_slot}{Name of the \code{input_type} data slot to use e.g. \code{orig}, if no prefix was added.}

\item{cluster_slot}{string specifying which clustering slot to use to find variable specified in \code{cluster_var}.}

\item{cluster_var}{string specifying variable name in \code{cluster_slot} that identifies cell population labels to be used (e.g. clusters or metaclusters).}

\item{method}{A string specifying which classification or regression model to use, by default \code{method = "knn"}. See \code{\link[caret]{train}} for possible values.}

\item{tuneLength}{An integer denoting the amount of granularity in the tuning parameter grid, default \code{tuneLength = 5}.}

\item{trControl}{A list of values that define how this function acts, default \code{trControl = caret::trainControl(method = "cv")}. See \code{\link[caret]{trainControl}} and <http://topepo.github.io/caret/using-your-own-model-in-train.html>.}

\item{seed}{A seed is set for reproducibility.}
}
\value{
\code{train_transfer_model} returns a \code{fcd} with the model and associated visualizations saved in \code{fcd$extras$lt_model}.
}
\description{
Train a machine learning model to transfer cell labels (this function implements the \code{caret} workflow)
}
\details{
train_transfer_model

The \code{train_transfer_model} uses \code{\link[caret]{train}}.
}
